from flask import Flask, jsonify, send_file
from flask_cors import CORS
import os
import time
from musicbeeipc import MusicBeeIPC, MBMD_TrackTitle, MBMD_Artist

app = Flask(__name__)
CORS(app)
mbIPC = MusicBeeIPC()

# Function to convert .tmp to .png
def convert_tmp_to_png(tmp_path):
    png_path = tmp_path.replace('.tmp', '.png')
    os.rename(tmp_path, png_path)
    return png_path

# Serve the image file
@app.route('/album_art')
def serve_album_art():
    if os.path.exists(current_artwork):
        return send_file(current_artwork)
    else:
        return '', 404

# Initialize variables to store the current track information
current_title = ""
current_artist = ""
current_artwork = ""

@app.route('/get_track_info')
def get_track_info():
    global current_title, current_artist, current_artwork

    # Get the current track information
    new_title = mbIPC.get_file_tag(MBMD_TrackTitle)
    new_artist = mbIPC.get_file_tag(MBMD_Artist)
    current_play_state = True if mbIPC.get_play_state() == 3 else False

    # Check if there's a change in track title or artist
    if new_title != current_title or new_artist != current_artist:
        # Update the current track information
        current_title = new_title
        current_artist = new_artist
        current_artwork = convert_tmp_to_png(mbIPC.get_artwork_url())

    return jsonify(
        trackTitle=current_title,
        artist=current_artist,
        playState=str(current_play_state)
    )


@app.route("/")
def main():
    instructions = """
    Hi! This is an OBS widget site, used for an audio widget. As of right now, it only works with
    the MusicBee app, but I'm soon to get it to work with the Windows Audio Controls (WAC).
    Until then, you need to install the MusicBee app from https://www.getmusicbee.com/downloads/
    Next, in a new tab, go to https://OBSmusicwidget.pages.dev/download to download the flask webserver required to get the
    """

if __name__ == '__main__':
    app.run(debug=False)
